/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.capability;

import dev.xkmc.fastprojectileapi.collision.EntityStorageHelper;
import dev.xkmc.l2library.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2library.capability.player.PlayerCapabilityNetworkHandler;
import dev.xkmc.l2library.capability.player.PlayerCapabilityTemplate;
import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.capability.GrazeHelper;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import dev.xkmc.youkaishomecoming.content.spell.item.SpellContainer;
import dev.xkmc.youkaishomecoming.events.DanmakuLastHitEvent;
import dev.xkmc.youkaishomecoming.events.EffectEventHandlers;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.data.YHTagGen;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class GrazeCapability
extends PlayerCapabilityTemplate<GrazeCapability> {
    public static final Capability<GrazeCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<GrazeCapability>(){});
    public static final PlayerCapabilityHolder<GrazeCapability> HOLDER = new PlayerCapabilityHolder(YoukaisHomecoming.loc("graze"), CAPABILITY, GrazeCapability.class, GrazeCapability::new, PlayerCapabilityNetworkHandler::new);
    private static final int MAX_GRAZE = 100;
    private static final int SHARD = 5;
    private static final int CYCLE = 3;
    private static final int WEAK = 60;
    private static final int GRAZE_CACHE = 10;
    @SerialClass.SerialField
    private int power;
    @SerialClass.SerialField
    private int hidden;
    @SerialClass.SerialField
    private int step;
    @SerialClass.SerialField
    private int bomb;
    @SerialClass.SerialField
    private int life;
    @SerialClass.SerialField
    private int invul;
    @SerialClass.SerialField
    private int weak;
    @SerialClass.SerialField
    private Map<UUID, CombatSession> sessions = new LinkedHashMap<UUID, CombatSession>();
    private boolean dirty = false;
    private int tempGraze = 0;
    private int lastGraze = 0;

    public void onClone(boolean isWasDeath) {
        if (isWasDeath) {
            this.power = 0;
            this.hidden = 0;
            this.step = 0;
            this.invul = 0;
            this.life = 0;
            this.bomb = 0;
            this.weak = 0;
            this.dirty = true;
        }
    }

    public void initStatus() {
        int initResource = GrazeHelper.getInitialResource(this.player) * 5;
        int initPower = GrazeHelper.getInitialPower(this.player) * 100;
        this.life = Math.max(initResource, this.life);
        this.bomb = Math.max(initResource, this.bomb);
        this.power = Math.max(initPower, this.power);
    }

    public void tick() {
        Object object;
        boolean full = EffectEventHandlers.isFullCharacter((LivingEntity)this.player);
        if (this.tempGraze > 0) {
            --this.tempGraze;
            double val = GrazeHelper.getGrazeEffectiveness(this.player);
            int count = (int)val;
            if ((double)this.player.m_217043_().m_188501_() < val - (double)count) {
                ++count;
            }
            for (int i = 0; i < count; ++i) {
                this.consumeGraze();
            }
            this.dirty = true;
        }
        if (this.invul > 0) {
            --this.invul;
        }
        if (this.weak > 0) {
            --this.weak;
        }
        int maxPower = GrazeHelper.getMaxPower(this.player) * 100;
        int maxResource = GrazeHelper.getMaxResource(this.player) * 5;
        if (this.power > maxPower) {
            this.power = maxPower;
        }
        if (this.life > maxResource) {
            this.life = maxResource;
        }
        if (this.bomb > maxResource) {
            this.bomb = maxResource;
        }
        if ((object = this.player.m_9236_()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)object;
            if (!full) {
                this.dirty = !this.sessions.isEmpty();
                this.sessions.clear();
            } else {
                for (Map.Entry entry : new ArrayList<Map.Entry<UUID, CombatSession>>(this.sessions.entrySet())) {
                    if (((CombatSession)entry.getValue()).youkai == null) {
                        this.dirty = true;
                    }
                    if (!((CombatSession)entry.getValue()).shouldRemove(sl, this.player)) continue;
                    this.sessions.remove(entry.getKey());
                    this.dirty = true;
                }
            }
            if (this.dirty) {
                this.sync();
            }
        }
        this.dirty = false;
        if (this.player.m_9236_().f_46443_) {
            GrazeHelper.globalInvulTime = this.invul;
            GrazeHelper.globalForbidTime = Math.max(this.invul, this.weak);
        }
    }

    public boolean graze() {
        if (this.invul > 0) {
            return false;
        }
        if (!EffectEventHandlers.isFullCharacter((LivingEntity)this.player)) {
            return false;
        }
        if (this.tempGraze < 10) {
            ++this.tempGraze;
        }
        boolean ans = this.player.f_19797_ != this.lastGraze;
        this.lastGraze = this.player.f_19797_;
        return ans;
    }

    private void consumeGraze() {
        if (this.power < GrazeHelper.getMaxPower(this.player) * 100) {
            ++this.power;
            return;
        }
        if (this.sessions.isEmpty()) {
            return;
        }
        ++this.hidden;
        if (this.hidden < 100) {
            return;
        }
        this.hidden -= 100;
        ++this.step;
        int max = GrazeHelper.getMaxResource(this.player) * 5;
        if (this.step == 3) {
            if (this.life < max) {
                ++this.life;
                this.step = 0;
            } else if (this.bomb < max) {
                ++this.bomb;
                --this.step;
            } else {
                --this.step;
            }
        } else if (this.bomb < max) {
            ++this.bomb;
        } else if (this.life < max) {
            ++this.step;
        }
    }

    public HitType performErase(YoukaiEntity e) {
        if (!EffectEventHandlers.isFullCharacter((LivingEntity)this.player)) {
            return HitType.NONE;
        }
        if (!this.sessions.containsKey(e.m_20148_())) {
            return HitType.ERASE;
        }
        if (this.invul > 0) {
            return HitType.INVUL;
        }
        for (CombatSession s : this.sessions.values()) {
            s.eraseDanmaku(this.player);
        }
        if (this.useBomb()) {
            return HitType.BOMB;
        }
        int maxLoss = (int)((Double)YHModConfig.COMMON.maxPowerLossOnMiss.get() * 100.0);
        int loss = Math.min(this.power / 2, maxLoss);
        this.power -= loss;
        this.dirty = true;
        this.invul = (Integer)YHModConfig.COMMON.missInvulTime.get();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            YoukaisHomecoming.HANDLER.toClientPlayer((SimplePacketBase)new GrazeHelper.GrazeToClient().set(1), sp);
            SpellContainer.clear(sp);
        }
        if (this.life < 5) {
            if (MinecraftForge.EVENT_BUS.post((Event)new DanmakuLastHitEvent(this.player, (LivingEntity)e))) {
                return HitType.LIFE;
            }
            for (CombatSession s : this.sessions.values()) {
                s.resetTarget(this.player);
            }
            this.sessions.clear();
            this.weak = 60;
            return HitType.LAST;
        }
        this.life -= 5;
        this.bomb = GrazeHelper.getInitialResource(this.player) * 5;
        return HitType.LIFE;
    }

    public boolean useBomb() {
        if (this.bomb < 5) {
            return false;
        }
        this.bomb -= 5;
        this.invul = (Integer)YHModConfig.COMMON.bombInvulTime.get();
        this.dirty = true;
        return true;
    }

    public float powerBonus() {
        if (!EffectEventHandlers.isFullCharacter((LivingEntity)this.player)) {
            return 0.0f;
        }
        int support = this.power / 100;
        return (float)support * ((Double)YHModConfig.COMMON.danmakuPowerBonus.get()).floatValue();
    }

    public List<InfoLine> getInfoLines() {
        if (!EffectEventHandlers.isFullCharacter((LivingEntity)this.player)) {
            return List.of();
        }
        InfoIcon icon = new InfoIcon(YoukaisHomecoming.loc("textures/gui/elements.png"), 20, 20);
        if (this.sessions.isEmpty()) {
            boolean bypass;
            boolean holding = this.player.m_21205_().m_204117_(YHTagGen.DANMAKU_SHOOTER) || this.player.m_21206_().m_204117_(YHTagGen.DANMAKU_SHOOTER);
            boolean bl = bypass = this.player.m_150110_().f_35937_ && this.player.m_6144_();
            if (!holding) {
                return List.of();
            }
            if (!bypass) {
                return List.of(new InfoLine("%.2f".formatted((double)this.power * 0.01), icon, 10, 10));
            }
        }
        return List.of(new InfoLine("%.1f".formatted((double)this.life * 1.0 / 5.0), icon, 0, 10), new InfoLine("%.1f".formatted((double)this.bomb * 1.0 / 5.0), icon, 0, 0), new InfoLine("%.2f".formatted((double)this.power * 1.0 / 100.0), icon, 10, 10), new InfoLine("%.2f".formatted((double)this.hidden * 1.0 / 100.0), icon, 10, 0));
    }

    public boolean isInSession(UUID uuid) {
        return this.sessions.containsKey(uuid);
    }

    public void initSession(YoukaiEntity youkai) {
        if (this.sessions.containsKey(youkai.m_20148_())) {
            return;
        }
        if (this.sessions.isEmpty()) {
            this.initStatus();
        }
        this.sessions.put(youkai.m_20148_(), new CombatSession().init(youkai));
        youkai.targets.add((LivingEntity)this.player);
        this.dirty = true;
    }

    public void stopSession(UUID uuid) {
        Player player;
        if (!this.sessions.containsKey(uuid)) {
            return;
        }
        this.sessions.remove(uuid);
        if (this.sessions.isEmpty() && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            SpellContainer.clear(sp);
        }
        this.dirty = true;
    }

    public boolean shouldHurt(LivingEntity le) {
        Mob mob;
        if (!EffectEventHandlers.isFullCharacter((LivingEntity)this.player)) {
            return true;
        }
        if (le instanceof YoukaiEntity) {
            YoukaiEntity youkai = (YoukaiEntity)le;
            if (this.weak > 0) {
                return false;
            }
            if (this.sessions.containsKey(youkai.m_20148_())) {
                return true;
            }
            if (youkai.targets.contains((LivingEntity)this.player)) {
                return true;
            }
            if (this.sessions.isEmpty()) {
                this.initSession(youkai);
                return true;
            }
            return false;
        }
        return this.sessions.isEmpty() || le instanceof Mob && (mob = (Mob)le).m_5448_() == this.player;
    }

    public Optional<LivingEntity> findAny(Player player) {
        return this.sessions.values().stream().findAny().map(e -> e.getTarget(player));
    }

    public void remove(UUID uuid) {
        this.sessions.remove(uuid);
    }

    public void setLife(int i) {
        this.life = i;
        this.dirty = true;
    }

    public void setBomb(int i) {
        this.bomb = i;
        this.dirty = true;
    }

    public void setPower(int i) {
        this.power = i;
        this.dirty = true;
    }

    public boolean isInvul() {
        return this.invul > 0;
    }

    public boolean isWeak() {
        return this.weak > 0;
    }

    public int getLife() {
        return this.life;
    }

    public int getBomb() {
        return this.bomb;
    }

    public int getPower() {
        return this.power;
    }

    public void sync() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            GrazeCapability.HOLDER.network.toClientSyncAll(sp);
        }
    }

    public static void register() {
    }

    @SerialClass
    public static class CombatSession {
        @SerialClass.SerialField
        private UUID uuid;
        @SerialClass.SerialField
        private int uid;
        private YoukaiEntity youkai;

        public CombatSession init(YoukaiEntity e) {
            this.uuid = e.m_20148_();
            this.uid = e.m_19879_();
            this.youkai = e;
            return this;
        }

        public boolean shouldRemove(ServerLevel sl, Player player) {
            if (this.youkai == null) {
                Entity entity = sl.m_8791_(this.uuid);
                if (entity instanceof YoukaiEntity) {
                    YoukaiEntity e;
                    this.youkai = e = (YoukaiEntity)entity;
                    this.uid = this.youkai.m_19879_();
                } else {
                    return true;
                }
            }
            if (!this.youkai.m_6084_() || !EntityStorageHelper.isPresent((Entity)this.youkai)) {
                return true;
            }
            return !this.youkai.targets.contains((LivingEntity)player);
        }

        @Nullable
        public LivingEntity getTarget(Player player) {
            LivingEntity le;
            if (this.youkai != null) {
                return this.youkai;
            }
            Entity entity = player.m_9236_().m_6815_(this.uid);
            return entity instanceof LivingEntity ? (le = (LivingEntity)entity) : null;
        }

        protected void resetTarget(Player player) {
            LivingEntity livingEntity = this.getTarget(player);
            if (livingEntity instanceof YoukaiEntity) {
                YoukaiEntity e = (YoukaiEntity)livingEntity;
                e.resetTarget(player);
            }
        }

        protected void eraseDanmaku(Player player) {
            LivingEntity livingEntity = this.getTarget(player);
            if (livingEntity instanceof YoukaiEntity) {
                YoukaiEntity e = (YoukaiEntity)livingEntity;
                e.eraseAllDanmaku(player);
            }
        }
    }

    public static enum HitType {
        NONE,
        INVUL,
        BOMB,
        LIFE,
        ERASE,
        LAST;


        public boolean skipDamage() {
            return this == BOMB || this == LIFE || this == INVUL || this == LAST;
        }

        public boolean erase() {
            return this == BOMB || this == LIFE || this == ERASE || this == LAST;
        }
    }

    public record InfoIcon(ResourceLocation loc, int w, int h) {
    }

    public record InfoLine(String text, InfoIcon icon, int x, int y) {
    }
}

